;(function(global) {
  'use strict'

  var base64
  if (typeof Buffer !== 'undefined') {
    base64 = function(str) {
      return (new Buffer(str)).toString('base64')
    }
  }
  else {
    base64 = global.btoa
  }

  var methods = [
    //http://tools.ietf.org/html/rfc2616
    'OPTIONS',
    'GET',
    'HEAD',
    'POST',
    'PUT',
    'DELETE',
    'TRACE',
    'CONNECT',
    //http://tools.ietf.org/html/rfc5789
    'PATCH'
  ];

  var joinPaths = function(paths) {
    if (typeof paths === 'string')
      return paths

    var joined = ''
    var length = 0
    var pathsLength = paths.length

    for (var i = 0; i < paths.length; i++) {
      var path = paths[i]
      if (typeof path !== 'string')
        throw 'TypeError: argument to joinPaths must be an array with strings'

      for (var y = 0; y < path.length; y++) {
        var l = path[y]
        if (l === '/' && joined[length - 1] === '/')
          continue

        joined += l
        length++
      }

      if (i !== pathsLength - 1 && joined[length - 1] !== '/') {
        joined += '/'
        length++
      }
    }

    return joined
  }

  var getPrototypeOf = function(obj) {
    if (Object.getPrototypeOf)
      return Object.getPrototypeOf(obj)
    else
      /* eslint-disable */
      return obj.__proto__
      /* eslint-enable */
  }

  var prototypeOfObject = getPrototypeOf({})

  var isObject = function(obj) {
    if (typeof obj !== 'object')
      return false

    return getPrototypeOf(obj) === prototypeOfObject || getPrototypeOf(obj) === null
  }

  var defaultOptions = {
    query: {},
    secure: false,
    host: 'localhost',
    path: '/',
    headers: {},
    method: 'GET',
    port: 80,
    jsonp: false,
    username: '',
    password: ''
  }

  var handleOptions = function(opts, overrides) {
    opts = opts || {}

    var options = {}

    for (var i in defaultOptions) {
      if (i === 'path') {
        if (typeof opts.path === 'string') {
          if (overrides && typeof overrides.path === 'string')
            options.path = joinPaths([overrides.path, opts.path])
          else
            options.path = joinPaths(opts.path)
        }
        else if (overrides && overrides.path === 'string') {
          options.path = joinPaths(overrides.path)
        }
        else
          options.path = joinPaths(defaultOptions.path)
      }
      else if (typeof opts[i] === typeof defaultOptions[i])
        options[i] = opts[i]
      else if (overrides && typeof overrides[i] === typeof defaultOptions[i])
        options[i] = overrides[i]
      else
        options[i] = defaultOptions[i]
    }

    options.method = options.method.toUpperCase()

    //jsonp
    if (opts.jsonp === true)
      opts.jsonp = 'callback'
    if (typeof opts.jsonp === 'string') {
      options.jsonp = opts.jsonp
      options.query[opts.jsonp] = 'HTTPClient' + Date.now()
    }

    //lower cases headers
    for (var k in options.headers) {
      var v = options.headers[k]
      delete options.headers[k]
      options.headers[k.toLowerCase()] = v
    }

    //basic auth
    if (opts.username && typeof opts.username === 'string' && opts.password && typeof opts.password === 'string') {
      var creds = opts.username + ':' + opts.password
      options.headers.authorization = 'Basic ' + base64(creds)
    }

    //body json
    if (Array.isArray(opts.body) || isObject(opts.body)) {
      options.body = JSON.stringify(opts.body)
      if (!options.headers['content-type'])
        options.headers['content-type'] = 'application/json; charset=utf-8'
    }
    //body string
    else if (typeof opts.body === 'string') {
      options.body = opts.body
      if (!options.headers['content-type'])
        options.headers['content-type'] = 'text/plain; charset=utf-8'
    }
    else if (opts.body !== undefined || opts.body !== null) {
      options.body = opts.body
    }

    return options
  }

  var getTypeFromHeaders = function(headers) {
    var type = ''
    if (typeof headers === 'object') {
      var contentType = headers['content-type']
      if (contentType)
        type = contentType.split(';')[0]
    }
    return type
  }

  var getSizeFromHeaders = function(headers) {
    var size = 0
    if (typeof headers === 'object') {
      var contentLength = headers['content-length']
      if (contentLength)
        size = parseInt(contentLength, 10)
    }
    return size
  }

  var Promise
  if (typeof module !== 'undefined' && module.exports) {
    if (!global.Promise) {
      try {
        Promise = require('es6-promise').Promise
      }
      catch (ex) {}
    }
  }
  else {
    Promise = global.Promise
  }

  //https://github.com/isaacs/inherits
  var inherits = (function() {
    if (typeof module !== 'undefined' && module.exports && typeof require !== 'undefined')
      return require('util').inherits
    else if (typeof Object.create === 'function') {
      return function(ctor, superCtor) {
        ctor.super_ = superCtor
        ctor.prototype = Object.create(superCtor.prototype, {
          constructor: {
            value: ctor,
            enumerable: false,
            writable: true,
            configurable: true
          }
        })
      }
    }
    else {
      return function(ctor, superCtor) {
        ctor.super_ = superCtor
        var TempCtor = function () {}
        TempCtor.prototype = superCtor.prototype
        ctor.prototype = new TempCtor()
        ctor.prototype.constructor = ctor
      }
    }
  })()

  var warn = function(message) {
    console.warn('HTTPClient.js warns: ' + message)
  }

  var utils = {
    handleOptions: handleOptions,
    joinPaths: joinPaths,
    getTypeFromHeaders: getTypeFromHeaders,
    getSizeFromHeaders: getSizeFromHeaders,
    getPrototypeOf: getPrototypeOf,
    Promise: Promise,
    methods: methods,
    defaultOptions: defaultOptions,
    inherits: inherits,
    warn: warn
  }

  if (typeof module !== 'undefined' && module.exports) {
    module.exports = utils
  } else {
    global.HTTPClient = {utils: utils}
  }
})(this)
;(function(global) {
  'use strict'

  var utils

  if (typeof module !== 'undefined' && module.exports) {
    utils = require('./utils')
  } else {
    utils = global.HTTPClient.utils
  }

  var Response = function() {
    this.headers = {}
    this.status = ''
    this.statusCode = NaN
    this.type = ''
    this.size = 0
  }
  Response.prototype.onend = function() {}
  Response.prototype.onprogress = function() {}
  Response.prototype.setHeaders = function(headers) {
    for (var i in headers)
      this.headers[i] = headers[i]

    this.type = utils.getTypeFromHeaders(this.headers)
    this.size = utils.getSizeFromHeaders(this.headers)
  }
  Response.prototype.setStatus = function(status) {
    this.statusCode = status
    this.status = status.toString()
  }

  if (typeof module !== 'undefined' && module.exports) {
    module.exports = Response
  } else {
    global.HTTPClient.Response = Response
  }
})(this)
;(function(global) {
  'use strict'

  var utils
  var Response

  if (typeof module !== 'undefined' && module.exports) {
    utils = require('./utils')
    Response = require('./Response')
  } else {
    utils = global.HTTPClient.utils
    Response = global.HTTPClient.Response
  }

  var Request = function(opts) {
    opts = utils.handleOptions(opts)

    for (var j in opts) {
      this[j] = opts[j]
    }

    this.response = new Response()
    this.impl = {}
  }
  Request.prototype.abort = function() {}
  Request.prototype.onresponse = function() {}
  Request.prototype.onprogress = function() {}
  Request.prototype.onerror = function() {}

  if (typeof module !== 'undefined' && module.exports) {
    module.exports = Request
  } else {
    global.HTTPClient.Request = Request
  }
})(this)
;(function (global) {
  'use strict'

  var HTTPClient = global.HTTPClient
  var Request = HTTPClient.Request
  var utils = HTTPClient.utils
  var document = global.document

  var formatQuery = function (query, sep, eq) {
    //separator character
    sep = sep || '&'
    //assignement character
    eq = eq || '='

    var querystring = ''
    if (typeof query === 'object') {
      for (var i in query) {
        querystring += i + eq + query[i] + sep
      }

      if (querystring.length > 0)
        querystring = '?' + querystring.slice(0, -1)
    }
    return querystring
  }

  var formatURL = function (obj) {
    var querystring = formatQuery(obj.query)
    return [
      obj.secure ? 'https' : 'http',
      '://',
      obj.host,
      obj.port ? ':' + obj.port : '',
      obj.path || '/',
      querystring,
      obj.hash || ''
    ].join('')
  }

  var parseStringHeaders = function (str) {
    var headers = {}
    if (str) {
      var lines = str.split('\n')
      for (var i = 0; i < lines.length; i++) {
        if (!lines[i])
          continue

        var keyvalue = lines[i].split(':')
        headers[keyvalue[0].toLowerCase()] = keyvalue.slice(1).join().trim()
      }
    }
    return headers
  }

  var XMLHttpRequest = global.XMLHttpRequest

  var jsonp = function (opts, fn) {
    var cb = opts.query[opts.jsonp]
    var url = formatURL(opts)

    var el = document.createElement('script')
    el.src = url
    el.async = true

    function done (err, res) {
      delete el.onerror
      delete global[cb]
      el.parentNode.removeChild(el)
      fn(err, res)
    }

    global[cb] = function(b) {
      done(null, b)
    }

    el.onerror = function(err) {
      done(err)
    }

    var head = document.head || document.getElementsByTagName('head')[0]
    head.appendChild(el)
  }

  var BrowserRequest = function(opts) {
    Request.call(this, opts)

    var response = this.response
    var request = this

    if (opts.body && (opts.method === 'GET' || opts.method === 'HEAD'))
      utils.warn('Request body ignored for GET and HEAD methods with XMLHttpRequest.')

    //jsonp
    if (typeof opts.jsonp === 'string') {
      if (opts.body) {
        utils.warn('Request body ignored for JSONP')
      }

      jsonp(opts, function(err, body) {
        if (err) {
          request.onerror(err)
        } else {
          request.onresponse(response)
          response.onend(body)
        }
      })
      return
    }

    var req = new XMLHttpRequest()
    this.impl.request = req

    req.addEventListener('error', function(err) {
      request.onerror(err)
    })

    req.addEventListener('readystatechange', function() {
      //0   UNSENT  open()has not been called yet.
      //1   OPENED  send()has not been called yet.
      //2   HEADERS_RECEIVED  send() has been called, and headers and status are available.
      //3   LOADING   Downloading; responseText holds partial data.
      //4   DONE  The operation is complete.
      // if (req.readyState === 1) {
      //   this.onopen();
      // }
      if (req.readyState === 2) {
        response.setStatus(req.status)
        var headers = parseStringHeaders(req.getAllResponseHeaders())
        response.setHeaders(headers)
        request.onresponse(response)
      }
      else if (req.readyState === 4) {
        response.onend(req.response)
      }
    })

    req.addEventListener('progress', function(e) {
      response.onprogress(e.loaded, e.lengthComputable ? e.total : null)
    })

    req.upload.addEventListener('progress', function(e) {
      request.onprogress(e.loaded, e.lengthComputable ? e.total : null)
    })

    req.open(opts.method, formatURL(opts), true)

    // if (this.responseType)
    //   req.responseType = this.responseType

    for (var k in opts.headers) {
      req.setRequestHeader(k, opts.headers[k])
    }

    req.send(opts.body)
  };
  BrowserRequest.prototype.abort = function() {
    this.req.abort()
  }

  utils.inherits(BrowserRequest, Request)

  global.HTTPClient.Request = BrowserRequest
})(this)
;(function(global) {
  'use strict'

  var utils
  var Request

  if (typeof module !== 'undefined' && module.exports) {
    utils = require('./utils')
    Request = require('./node')
  }
  else {
    utils = global.HTTPClient.utils
    Request = global.HTTPClient.Request
  }

  var HTTPClient = function(opts, fn) {
    // new HTTPClient(opts)
    if (!fn) {
      opts = utils.handleOptions(opts)

      for (var i in opts)
        this[i] = opts[i]
    }
    // HTTPClient(opts, fn)
    else {
      var req = new HTTPClient()
      req.request(opts, fn)
    }
  }
  var request = function(opts, fn) {
    if (typeof opts === 'string' || Array.isArray(opts))
      opts = {path: opts}

    opts = utils.handleOptions(opts, this)

    var req = new Request(opts)
    if (!fn)
      return req

    req.onerror = function(err) {
      fn(err)
    }
    req.onresponse = function(response) {
      if (fn.length < 3) {
        return fn(null, response)
      }

      response.onend = function(body) {
        fn(null, response, body)
      }
    }
    return req
  }

  HTTPClient.request = request
  HTTPClient.prototype.request = request

  utils.methods.forEach(function(method) {
    var fn = function(opts, fn) {
      if (typeof opts === 'string')
        opts = {path: opts}

      opts.method = method

      return this.request(opts, fn)
    }

    // instance
    HTTPClient.prototype[method] = fn
    HTTPClient.prototype[method.toLowerCase()] = fn
    // static
    HTTPClient[method] = fn
    HTTPClient[method.toLowerCase()] = fn
  })

  if (typeof module !== 'undefined' && module.exports) {
    module.exports = HTTPClient
  } else {
    global.HTTPClient = HTTPClient
    global.HTTPClient.utils = utils
  }
})(this)
