const { ipcRenderer } = require('electron');

// Expose IPC methods to the global window object
window.electronAPI = {
  showSaveDialog: () => ipcRenderer.invoke('show-save-dialog'),
  showOpenDialog: () => ipcRenderer.invoke('show-open-dialog'),
  writeFile: (fileName, data) => ipcRenderer.invoke('write-file', fileName, data),
  readFile: (fileName) => ipcRenderer.invoke('read-file', fileName),
  showSaveDialogWithDefault: (defaultPath) => ipcRenderer.invoke('show-save-dialog-with-default', defaultPath)
};

console.log('Simple preload script loaded successfully');